/*  Änderungen an Arbeitsplätzen in die KSVBA-Ressourcen übertragen. */
CREATE OR REPLACE FUNCTION scheduling.sync__ksvba__resource() RETURNS trigger AS $$
    BEGIN

        IF ( TG_OP = 'DELETE' ) THEN

            -- Debug
            PERFORM LogDebugVerbose( message => format( 'delete resource(s), because connected ksvba %s was deleted;', old.ksb_id ) );

            DELETE FROM scheduling.resource
            WHERE
                context_id = old.ksb_id
            AND context = 'ksvba';

            RETURN old;

        -- Insert or Update
        ELSE

            -- Wenn der Arbeitsplatzname leer und die Maschinenanzahl 0 ist, dann
            IF coalesce( new.ksb_ks_ba_babz, '' ) = '' AND new.ksb_ks_ba = 0 THEN

                -- Debug
                PERFORM LogDebugVerbose( message => format( 'delete resource(s), because connected ksvba %s has no name (%s) and no machines (%s);', new.ksb_id, new.ksb_ks_ba_babz, new.ksb_ks_ba ) );

                -- ... Arbeitsplatz-Ressource löschen.
                DELETE FROM scheduling.resource
                WHERE
                        context_id = old.ksb_id
                    AND context = 'ksvba';

            -- Der Arbeitsplatzname ist gesetzt oder eine Maschinenanzahl größer 0 ist vergeben, dann ...
            ELSE

                -- Debug
                PERFORM LogDebugVerbose( message => format( 'create or update resource, because connected ksvba %s has name (%s) or machines (%s);', new.ksb_id, new.ksb_ks_ba_babz, new.ksb_ks_ba ) );

                -- ... Arbeitsplatz-Ressource anlegen oder aktualisieren.
                INSERT INTO scheduling.resource
                            ( context, context_id, ta_fk         )
                     VALUES ( 'ksvba', new.ksb_id, new.ksb_ks_ba )
                ON CONFLICT ( context, context_id )
                  DO UPDATE
                        SET ta_fk = new.ksb_ks_ba;

            END IF;

            RETURN new;

        END IF;

    END $$ language plpgsql;
  --
  DROP TRIGGER IF EXISTS sync_ksvba_resource_a__iu ON ksvba; -- Alter Name des Triggers
  DROP TRIGGER IF EXISTS ksvba_005_sync_resource_a__iu ON ksvba;
  CREATE TRIGGER ksvba_005_sync_resource_a__iu
    AFTER INSERT
    OR UPDATE OF ksb_ks_ba_babz, ksb_ks_ba, ksb_timestart, ksb_timeend
    ON ksvba
    FOR EACH ROW
    EXECUTE PROCEDURE scheduling.sync__ksvba__resource();
  --
  DROP TRIGGER IF EXISTS sync_ksvba_resource_b__d ON ksvba; -- Alter Name des Triggers; -- Alter Name des Triggers
  DROP TRIGGER IF EXISTS ksvba_005_sync_resource_b__d ON ksvba;
  CREATE TRIGGER ksvba_005_sync_resource_b__d
    BEFORE DELETE
    ON ksvba
    FOR EACH ROW
    EXECUTE PROCEDURE scheduling.sync__ksvba__resource();
  --
  SELECT tsystem.function__drop_by_regex( 'sync_ksvba_resource', 'tabk', _commit => true ); -- Alter Name der Trigger-Funktion.
